/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWMilestoneUsageDialog;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWExpressionCellEditor;
import filenet.vw.toolkit.design.property.tables.VWMilestonesTableModel;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWMilestonesTabPanel
extends JPanel
implements IVWToolbarBorderActionListener,
TableModelListener,
ListSelectionListener,
IVWTableActionListener {
    private VWToolbarBorder m_milestoneToolbar = null;
    private VWTable m_milestoneTable = null;
    private VWMilestonesTableModel m_milestoneTableModel = null;
    private boolean m_isFirstTime = true;
    private VWAuthPropertyData m_authPropertyData = null;

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_isFirstTime) {
            this.m_isFirstTime = false;
            if (this.m_milestoneTable != null) {
                int[] columnSizes = null;
                int width = this.m_milestoneTable.getViewPortWidth();
                columnSizes = this.m_authPropertyData.getShowInheritedProperties() ? new int[]{20, width / 3, 50, width - (columnSizes[0] + columnSizes[1] + columnSizes[2])} : new int[]{width / 3, 50, width - (columnSizes[0] + columnSizes[1])};
                this.m_milestoneTable.fitColumnsInTable(columnSizes);
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_milestoneToolbar) {
            switch (event.getID()) {
                case 1: {
                    this.performUpAction();
                    break;
                }
                case 2: {
                    this.performDownAction();
                    break;
                }
                case 0x10000000: {
                    this.performDeleteAction();
                    break;
                }
                case 16384: {
                    this.performMilestoneUsageAction();
                }
            }
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow > this.m_milestoneTable.getRowCount() - 1) {
                    nRow = this.m_milestoneTable.getRowCount() - 1;
                }
                if (nRow == this.m_milestoneTable.getSelectedRow()) {
                    this.m_milestoneTable.clearSelection();
                }
                this.m_milestoneTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (!event.getValueIsAdjusting()) {
                int nRowCount;
                this.m_milestoneToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_milestoneToolbar.getClientPanel(), 2, Integer.MAX_VALUE));
                int nRowIndex = this.m_milestoneTable.getSelectedRow();
                if (this.m_milestoneTableModel != null && nRowIndex != -1 && nRowIndex != (nRowCount = this.m_milestoneTableModel.getRowCount()) - 1) {
                    int nButtons = 16387;
                    if (this.m_milestoneTableModel.canDeleteRow(nRowIndex)) {
                        nButtons |= 0x10000000;
                    }
                    this.m_milestoneToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_milestoneToolbar.getClientPanel(), 1, nButtons));
                    if (nRowIndex == 0) {
                        this.m_milestoneToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_milestoneToolbar.getClientPanel(), 2, 1));
                    }
                    if (nRowIndex == nRowCount - 2) {
                        this.m_milestoneToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_milestoneToolbar.getClientPanel(), 2, 2));
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                if (this.m_milestoneTable == null) break;
                this.m_milestoneTable.stopEditing();
            }
        }
    }

    protected void init(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.createControls();
        this.reinitialize();
        this.m_authPropertyData.getTableActionEventNotifier().addTableActionListener(this);
    }

    protected void reinitialize() {
        if (this.m_milestoneTableModel != null) {
            this.m_milestoneTableModel.reinitialize();
        }
        this.m_milestoneTable.clearSelection();
        this.m_milestoneTable.setRowSelectionInterval(0, 0);
    }

    protected void stopEditing() {
        if (this.m_milestoneTable != null) {
            this.m_milestoneTable.stopEditing();
        }
    }

    protected void releaseReferences() {
        this.m_authPropertyData.getTableActionEventNotifier().removeTableActionListener(this);
        if (this.m_milestoneToolbar != null) {
            this.m_milestoneToolbar.removeToolbarBorderActionNotifier(this);
            this.m_milestoneToolbar.releaseReferences();
            this.m_milestoneToolbar = null;
        }
        if (this.m_milestoneTable != null) {
            this.m_milestoneTable.getSelectionModel().removeListSelectionListener(this);
            this.m_milestoneTable = null;
        }
        if (this.m_milestoneTableModel != null) {
            this.m_milestoneTableModel.removeTableModelListener(this);
            this.m_milestoneTableModel = null;
        }
        this.m_authPropertyData = null;
        this.removeAll();
    }

    private void createControls() {
        TableColumn tcElement;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.m_milestoneToolbar = new VWToolbarBorder(VWResource.s_milestonesStr, 268451843);
        this.m_milestoneToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_milestoneToolbar.getClientPanel(), 2, Integer.MAX_VALUE));
        this.m_milestoneToolbar.addToolbarBorderActionNotifier(this);
        this.add((Component)this.m_milestoneToolbar, "Center");
        JPanel milestonePanel = this.m_milestoneToolbar.getClientPanel();
        milestonePanel.setLayout(new GridLayout());
        this.m_milestoneTableModel = new VWMilestonesTableModel(this.m_authPropertyData);
        this.m_milestoneTableModel.addTableModelListener(this);
        this.m_milestoneTable = new VWTable(this.m_milestoneTableModel);
        this.m_milestoneTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.m_milestoneTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        this.m_milestoneTable.getSelectionModel().addListSelectionListener(this);
        this.m_milestoneTable.getSelectionModel().setSelectionMode(0);
        if (this.m_authPropertyData.getShowInheritedProperties() && (tcElement = this.m_milestoneTable.getColumnModel().getColumn(this.m_milestoneTableModel.getActualColumnIndex(0))) != null) {
            tcElement.setMaxWidth(20);
            tcElement.setMinWidth(20);
        }
        if ((tcElement = this.m_milestoneTable.getColumnModel().getColumn(this.m_milestoneTableModel.getActualColumnIndex(3))) != null) {
            tcElement.setCellEditor(new VWExpressionCellEditor(this.m_authPropertyData));
            tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
        }
        milestonePanel.add(new JScrollPane(this.m_milestoneTable));
    }

    private void performUpAction() {
        int nRowIndex = this.m_milestoneTable.getSelectedRow();
        if (nRowIndex > 0) {
            this.m_milestoneTableModel.up(nRowIndex);
            this.m_milestoneTable.setRowSelectionInterval(nRowIndex - 1, nRowIndex - 1);
        }
    }

    private void performDownAction() {
        try {
            int nRowIndex = this.m_milestoneTable.getSelectedRow();
            if (nRowIndex < this.m_milestoneTableModel.getRowCount() - 2) {
                this.m_milestoneTableModel.down(this.m_milestoneTable.getSelectedRow());
                this.m_milestoneTable.setRowSelectionInterval(nRowIndex + 1, nRowIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performDeleteAction() {
        int rowIndex = this.m_milestoneTable.getSelectedRow();
        this.m_milestoneTableModel.deleteItem(rowIndex);
        if (--rowIndex < 0) {
            rowIndex = 0;
        }
        this.m_milestoneTable.setRowSelectionInterval(rowIndex, rowIndex);
    }

    private void performMilestoneUsageAction() {
        try {
            int rowIndex = this.m_milestoneTable.getSelectedRow();
            VWMilestoneDefinition milestoneDef = this.m_milestoneTableModel.getItemAt(rowIndex);
            if (milestoneDef != null) {
                VWMilestoneUsageDialog milestoneUsageDialog = new VWMilestoneUsageDialog(this.m_authPropertyData.getMainContainer(), this.m_authPropertyData, milestoneDef);
                milestoneUsageDialog.init();
                if (milestoneUsageDialog.hasMaps()) {
                    milestoneUsageDialog.setVisible(true);
                } else {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), VWResource.s_noAvailableWritableMaps, 2);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

